<?php

define('LANG_IT', "/^https:\/\/[www.]*microtest.net\/it\/\w/");

class ExportFlamingo {
  public $instance;
  
  public function __construct(){
    $dbhost 	  = "localhost";
    $username 	= "imlilyaq_microtestuser";
    $password 	= "eTO]=?g.Guvd";
    $dbname 	  = "imlilyaq_microtestdb";
    
    $con = mysqli_connect($dbhost, $username, $password, $dbname) or die("Connection failed: " . mysqli_connect_error());
    mysqli_set_charset($con, 'utf8');
    
    if (mysqli_connect_errno()) {
      printf("Connect failed: %s\n", mysqli_connect_error());
      exit();
    } else {
      $this->instance = $con;
    }
  }

  public function loop() {
    $query = "SELECT 
                p.id,
                p.post_date,
                (SELECT meta_value FROM mtn_postmeta WHERE post_id = pm.post_id AND meta_key = '_field_datasheet_product') datasheet,
                (SELECT meta_value FROM mtn_postmeta WHERE post_id = pm.post_id AND meta_key = '_field_product_name') more_info,
                COALESCE((SELECT meta_value FROM mtn_postmeta WHERE post_id = pm.post_id AND meta_key = '_field_your-name'),(SELECT meta_value FROM mtn_postmeta WHERE post_id = pm.post_id AND meta_key = '_field_first-name')) nome,
                COALESCE((SELECT meta_value FROM mtn_postmeta WHERE post_id = pm.post_id AND meta_key = '_field_your-surname'),(SELECT meta_value FROM mtn_postmeta WHERE post_id = pm.post_id AND meta_key = '_field_last-name')) cognome,
                (SELECT meta_value FROM mtn_postmeta WHERE post_id = pm.post_id AND meta_key = '_field_country') country,
                (SELECT meta_value FROM mtn_postmeta WHERE post_id = pm.post_id AND meta_key = '_field_phone') phone,
                (SELECT meta_value FROM mtn_postmeta WHERE post_id = pm.post_id AND meta_key = '_field_company') company,
                COALESCE((SELECT meta_value FROM mtn_postmeta WHERE post_id = pm.post_id AND meta_key = '_from_email'),(SELECT meta_value FROM mtn_postmeta WHERE post_id = pm.post_id AND meta_key = '_field_email')) email,
                (SELECT meta_value FROM mtn_postmeta WHERE post_id = pm.post_id AND meta_key = '_field_acceptance-newsletter') iscrizione,
                meta_value,
                t.name channel
              FROM mtn_postmeta pm
              INNER JOIN mtn_posts p ON (pm.post_id = p.id)
              LEFT OUTER JOIN mtn_term_relationships tr ON (p.id = tr.object_id)
              LEFT OUTER JOIN mtn_term_taxonomy tt ON (tr.term_taxonomy_id = tt.term_taxonomy_id)
              LEFT OUTER JOIN mtn_terms t ON (tt.term_id = t.term_id)
              WHERE p.post_id IN (SELECT ID FROM mtn_posts WHERE post_type = 'flamingo_inbound') 
              AND pm.meta_key='_meta'";

    $contatti = $this->instance->query($query);

    $riga = "id,data_invio,datasheet,more_info,nome,cognome,nazione,tel,azienda,email,newsletter,canale,lingua";
    while($c = $contatti->fetch_array()) {
      $url = unserialize($c[12]);
      $lang = preg_match(LANG_IT, $url['url'])?"it":"en";

      $iscrizione = unserialize($c[11]);

      $riga .= $c[0].","; // id
      $riga .= "\"".$c[1]."\","; // post_date
      $riga .= "\"".$c[2]."\","; // datasheet
      $riga .= "\"".$c[3]."\","; // more_info
      $riga .= "\"".$c[4]."\","; // nome
      $riga .= "\"".$c[5]."\","; // cognome
      $riga .= "\"".$c[6]."\","; // country
      $riga .= "\"".$c[7]."\","; // phone
      $riga .= "\"".$c[8]."\","; // company
      $riga .= "\"".$c[9]."\","; // from_email
      $riga .= "\"".$c[10]."\",";// email
      $riga .= "\"".$iscrizione[0]."\",";// iscrizione
      $riga .= "\"".$c[12]."\","; // channel
      $riga .= "\"".$lang."\"\n"; // lingua
      
      file_put_contents('./flamingo.csv', $riga, FILE_APPEND);
    }
  }
}

$script = new ExportFlamingo();
$script->loop();