<?php
add_action( 'init', 'create_TaxAndPost' );

function create_TaxAndPost()
{
  $label_feats = array(
    'name'              => _x( 'Tag','taxonomy general name' ),
    'singular_name'     => _x( 'Tag', 'taxonomy singular name' ),
    'search_items'      => __( 'Cerca tag' ),
    'all_items'         => __( 'Tutti i tags' ),
    'parent_item'       => __( 'Tag genitore' ),
    'parent_item_colon' => __( 'Tag genitore:' ),
    'edit_item'         => __( 'Modifica tag' ),
    'update_item'       => __( 'Aggiorna tag' ),
    'add_new_item'      => __( 'Aggiungi tag' ),
    'new_item_name'     => __( 'Nuovo nome tag' ),
    'menu_name'         => 'Tags',
  );

  $arg_feats = array(
    'labels'            => $label_feats,	
    'public'            => false,
    'query_var'         => true,
    'rewrite'           => false,
    'show_ui'           => true,
    'show_admin_column' => true,
    'hierarchical'      => true,
    'can_export'        => true,
    'sort'              => true
  );
	
	register_taxonomy( 'tags', 'tag', $arg_feats);

  $label_tax = array(
    'name'              => _x( 'Categoria', 'taxonomy general name' ),
    'singular_name'     => _x( 'Categoria', 'taxonomy singular name' ),
    'search_items'      => __( 'Cerca categorie' ),
    'all_items'         => __( 'Tutte le categorie' ),
    'parent_item'       => __( 'Categoria genitore' ),
    'parent_item_colon' => __( 'Categoria genitore:' ),
    'edit_item'         => __( 'Modifica categoria' ),
    'update_item'       => __( 'Aggiorna categoria' ),
    'add_new_item'      => __( 'Aggiungi categoria' ),
    'new_item_name'     => __( 'Nuovo nome categoria' ),
    'menu_name'         => 'Categorie',
  );

  $arg_tax = array(
    'labels'            => $label_tax,
    'public'            => true,
    'rewrite'           => array('slug' => 'product-category'),
    'show_admin_column' => true,
    'query_var'         => true,
    'show_ui'           => true,
    'hierarchical'      => true,
    'can_export'        => true,
    'sort'              => true
  );
	
  register_taxonomy('categorie', 'categoria', $arg_tax);

  $labels = array(
    'name'               => __( 'Products' ),
    'singular_name'      => __( 'Product' ),
    'menu_name'          => __( 'Products' ),
    'name_admin_bar'     => __( 'Products' ),
    'add_new'            => __( 'Add new' ),
    'add_new_item'       => __( 'Add new product' ),
    'new_item'           => __( 'New Product' ),
    'edit_item'          => __( 'Edit Product' ),
    'view_item'          => __( 'View Product' ),
    'all_items'          => __( 'All products' ),
    'search_items'       => __( 'Search products' ),
    'parent_item_colon'  => __( 'Parent Product' ),
    'not_found'          => __( 'Products not found' ),
    'not_found_in_trash' => __( 'No product in trash' )
  );

  $args = array(
		'labels'              => $labels,
		'public'              => true,
    'publicly_queryable'  => true,
    'exclude_from_search' => false,
    'query_var'           => true,
    'has_archive'         => true,
    'can_export'          => true,
    'menu_position'       => 6,
    'menu_icon'           => 'dashicons-games',
    'show_ui'             => true,
    'taxonomies'          => array('categorie'), // Tolti i tag, 10.2.22 PP
    'supports'            => array('title', 'author','page-attributes','thumbnail', 'revisions', 'excerpt', 'custom-fields')
	);

  register_post_type('products', $args);
}