<?php
require_once(get_stylesheet_directory().'/cpt_products.php');
require_once(get_stylesheet_directory().'/cpt_applications.php');
require_once(get_stylesheet_directory().'/cpt_clients.php');
require_once(get_stylesheet_directory().'/cpt_positions.php');
require_once(get_stylesheet_directory().'/cpt_events.php');
require_once(get_stylesheet_directory(). '/breadcrumbs.php');

// style and scripts
add_action('wp_enqueue_scripts', 'bootscore_child_enqueue_styles');
function bootscore_child_enqueue_styles() {
  $versione = '1.093' /* rimozione swiper revolution dalla hoome con lo swiper custom */;
  // style.css
  wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css', [], $versione );
  wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/css/custom.css', [], $versione );
  wp_enqueue_style( 'another-child-style', get_stylesheet_directory_uri() . '/css/custom-another.css', [], $versione );
  wp_enqueue_style( 'responsive-style', get_stylesheet_directory_uri() . '/css/responsive.css', [], $versione );
  wp_enqueue_style( 'custom-2024-style', get_stylesheet_directory_uri() . '/css/custom-2024.css', [], $versione );


  wp_enqueue_style( 'owlcarousel-min-style', get_stylesheet_directory_uri() . '/lib/owlcarousel/assets/owl.carousel.min.css' );
  wp_enqueue_style( 'owlcarousel-default-style', get_stylesheet_directory_uri() . '/lib/owlcarousel/assets/owl.theme.green.min.css' );
  //   wp_enqueue_style('mautic', get_stylesheet_directory_uri() . '/css/mautic.css');

  // Compiled Bootstrap
  $modified_bootscoreChildCss = date('YmdHi', filemtime(get_stylesheet_directory() . '/css/lib/bootstrap.min.css'));
  wp_enqueue_style('bootstrap', get_stylesheet_directory_uri() . '/css/lib/bootstrap.min.css', array('parent-style'), $modified_bootscoreChildCss);
  
  // custom.js
  wp_enqueue_script('custom-js', get_stylesheet_directory_uri() . '/js/custom.js', false, $versione, true);
  wp_enqueue_script('owlcarousel-js', get_stylesheet_directory_uri() . '/lib/owlcarousel/owl.carousel.min.js', false, '', true);


   /* libreria swiper per carousel */
  wp_enqueue_style('swipe-style-cdn', 'https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css');
  wp_enqueue_script('swipe-js-cdn', 'https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js');
}

// Aggiorno il CSS nell’area amministratore
function admin_style() {
  wp_enqueue_style('admin-style', get_stylesheet_directory_uri() . '/css/custom-admin.css');
}

// Esegue la funzione admin_style() all’azione admin_enqueue_scripts di WP
add_action('admin_enqueue_scripts', 'admin_style');

// show featured images in dashboard
add_image_size( 'microtest-admin-post-featured-image', 60, 60, false );

// Add the posts and pages columns filter. They both use the same function.
add_filter('manage_products_posts_columns', 'microtest_add_post_admin_thumbnail_column', 2);
//add_filter('manage_pages_columns', 'microtest_add_post_admin_thumbnail_column', 2);

// Add the column
function microtest_add_post_admin_thumbnail_column($microtest_columns){
    //$microtest_columns['microtest_thumb'] = __('Image');
    $microtest_columns = array('microtest_thumb' => __('Image')) + $microtest_columns;
    return $microtest_columns;
}

// Manage Post and Page Admin Panel Columns
add_action('manage_posts_custom_column', 'microtest_show_post_thumbnail_column', 5, 2);
add_action('manage_pages_custom_column', 'microtest_show_post_thumbnail_column', 5, 2);

// Get featured-thumbnail size post thumbnail and display it
function microtest_show_post_thumbnail_column($microtest_columns, $microtest_id){
    switch($microtest_columns){
        case 'microtest_thumb':
        if( function_exists('the_post_thumbnail') ) {
            echo the_post_thumbnail( 'microtest-admin-post-featured-image' );
        }
        else
            echo 'hmm… your theme doesn\'t support featured image…';
        break;
    }
}

/**
 * Aggiunge il combi select al WPCF7 Careers
 * @link: https://pineco.de/dynamic-select-list-in-contact-form-7/
 */
function adp_dynamic_select_field_values ( $scanned_tag, $replace ) {  

	if ( $scanned_tag['name'] != 'position' ) return $scanned_tag;

	$rows = get_posts(
		array ( 
			'post_type' => 'position',  
			'numberposts' => -1,  
			'orderby' => 'title',  
			'order' => 'ASC' ,
   			'suppress_filters' => false,
		)
	);  

	if ( ! $rows ) return $scanned_tag;

	foreach ( $rows as $row ) {  
			$scanned_tag['raw_values'][] = $row->post_title . '|' . $row->post_title;
	}

	$pipes = new WPCF7_Pipes($scanned_tag['raw_values']);

	$scanned_tag['values'] = $pipes->collect_befores();
	$scanned_tag['labels'] = $pipes->collect_afters();
	$scanned_tag['pipes'] = $pipes;

	return $scanned_tag;  
}  

add_filter( 'wpcf7_form_tag', 'adp_dynamic_select_field_values', 10, 2); 

function wpdocs_custom_excerpt_length( $length ) {
	return 20;
}
add_filter( 'excerpt_length', 'wpdocs_custom_excerpt_length', 999 );


/* questo filtro aggiungge i file richiesti dagli utenti tramite il form alla mail che riceveranno */
/* https://stackoverflow.com/questions/48189010/dynamically-attaching-file-to-contact-form-7-e-mail */
add_filter('wpcf7_mail_components', 'custom_wpcf7_mail_components');
function custom_wpcf7_mail_components($components) {
    //Get current form
    $wpcf7 = WPCF7_ContactForm::get_current();
    $attachment_file_path = '';
    
    /* id dei form che dovranno allegare i file nella mail degli utenti, bisognerà duplicarli per l'inglese */
    $cf7IdArray = [2467,2469,2468,774,2467,2464];//Da verificare se basta mettere i 2 form ita e eng di DATASHEET
    if (in_array($wpcf7->id,$cf7IdArray)) {
        
        // get current SUBMISSION instance
        $submission = WPCF7_Submission::get_instance();

        if ($submission) {
            // get submission data
            $data = $submission->get_posted_data();

            if (!str_contains($components['subject'], "Admin")) {
                //$upload_dir = get_stylesheet_directory_uri();
                $upload_dir = WP_CONTENT_DIR."/themes/microtest-official";
                
                $file_name = $data['datasheet_file'];//E' nel custom filed
                $file_dir = 'pdf';
                $attachment_file_path = $upload_dir .'/'.$file_dir.'/'.$file_name;
                //append new file to mail attachments
                $components['attachments'][] = $attachment_file_path;
            }
        }
    }
    
    return $components;
}

add_filter('wpcf7_autop_or_not', '__return_false');

add_action( 'wp_ajax_acconsentito', 'acconsentito_wp_ajax_function' );
add_action( 'wp_ajax_nopriv_acconsentito', 'acconsentito_wp_ajax_function' );

function acconsentito_wp_ajax_function() {
    $page_id = $_POST['id'];
    $page = get_post($page_id);

    // $duration = time()+60*60;//Un'ora
    // setcookie("lettura_acconsentita","1",$duration,"/","www.microtest.net");

    // Cosa faccio nel DB???

    echo $page->post_content;
    exit;
}