<?php
/*
*Template Name: Test House
*@link https://codex.wordpress.org/Template_Hierarchy
*@package Microtest
*/

get_header();

$args = array(
  'post_type' => 'applications'
);

$query = new WP_Query($args);
$apps = array();

while( $query->have_posts() ) {
  $query->the_post();
  array_push( 
    $apps, 
    array( 
      'title' => get_the_title(), 
      'icona' => get_field( 'icona_verde' ),
      'id'    => get_the_ID(),
      'link'  => get_the_permalink(),
    )
  );
}

wp_reset_postdata();
?>
<main id="content" class="main-test-house">
  <div class="the-title">
    <h2><?php the_title(); ?></h2>
  </div>

  <section id="section-1" class="section-1">
    <div class="container-fluid">
      <div class="row">
        <div class="col-md-6 bloccoImmagini">
          <div class="img-1">
            
          </div>          
          <div class="img-2">
            
          </div>
        </div>        
        <div class="col-md-6 padding40">
          <?php echo get_field('section_1'); ?>
          <div id="applications">
            <h4 class="apps-title"><?php _e('Applications', 'microtest'); ?></h4>
              <div class="applicationsContainer">
                <?php foreach($apps as $app) : ?>
                  <a href="<?= $app['link'] ?>">
                    <div class="app-img">
                      <img src="<?= $app['icona'] ?>">
                    </div>
                    <figcaption class="figure-caption app-text"><?= $app['title'] ?></figcaption>
                  </a>
                <?php endforeach ?>
              </div>
          </div>
          
          <?php $linguaAttuale = ICL_LANGUAGE_CODE; ?>
          <div class="sezione-form form-servizi">
            <?php if($linguaAttuale === 'en' || $linguaAttuale === 'zh-hans') { ?>
              <?php echo do_shortcode('[contact-form-7 id="dfc4f85" title="Contacts EN"]') ?>
            <?php } ?> 
            <?php if($linguaAttuale === 'it') { ?>
              <?php echo do_shortcode('[contact-form-7 id="73e3489" title="Contacts IT"]') ?>
            <?php } ?>
          </div>
        </div>
      </div>
    </div>
    <!-- <div class="block-left">
      <div class="img-1"></div>
    </div>
    <div class="block-right">
      <?php echo get_field('section_1'); ?>
      <div id="applications" class="row">
        <h4 class="apps-title"><?php _e('Applications', 'microtest'); ?></h4>
        <div class="container">
          <div class="immagini">
            <?php foreach($apps as $app) : ?>
              <a href="/applications/<?= get_post_field('post_name', $app['id']); ?>">
                <div class="app-img">
                  <img src="<?= $app['icona'] ?>">
                  <figcaption class="figure-caption app-text"><?= $app['title'] ?></figcaption>
                </div>
              </a>
            <?php endforeach ?>
          </div>
        </div>
      </div>
    </div> -->
  </section>

  <section id="section-2" class="section-2">
    <div class="container">
      <?php echo get_field('section_2'); ?>
    </div>
  </section>

  <section id="section-3" class="section-3">
    <div class="container">
      <?php echo get_field('section_3'); ?>
    </div>
  </section>

  <section id="section-4" class="section-4">
    <div class="container">
      <?php echo get_field('section_4'); ?>
    </div>
  </section>  
  <section id="section-5" class="section-5">
    <div class="container">
      <?php echo get_field('section_5'); ?>
      <script>
        <?php /* questo js serve per html contenuto in section_5 */ ?>
        jQuery(document).ready(function($){
          $('.immagine-hatinagp').on('click', function(){
            $(this).toggleClass('cliccato');
          })
        });
      </script>

      

    </div>
  </section>

</main>

<?php get_footer();