<?php
/**
 * Template Name: Pagina Interattiva
 *
 * @package WordPress
 */

 define('DONOTCACHEPAGE', true);

  get_header();
  global $post;
  $p_id = $post->ID;
?>

<style>
  .langSwitcher{
    display: none;
  }
  button{
    outline: 0;
    border: 0;
    box-shadow: unset;
  }
  .interattiva{
    min-height: calc(100vh - 175px);
  }
  .initial-h4{
    margin-top: 20px;
  }
  .acconsento,
  .bottone-scarica-pdf a{
    background-color: var(--coloreprimario);
    border: 3px solid var(--coloreprimario);
    color: white!important;
    border-radius: 10px 10px 10px 0;
    /* margin-right: 30px; */
    box-shadow: unset!important;
    display: inline-block;
  }
  .bottone-scarica-pdf{
    margin-top: 15px;
    margin-right: 0;
  }
  .bottone-scarica-pdf a{
    padding: 10px;
    margin-right: 0;
  }
  .acconsento.disabled{
    pointer-events: none;
    opacity: 0.5;
  }
  .acconsento:hover,
  .bottone-scarica-pdf a:hover{
    border: 3px solid black;
  }
  .rifiuto{
    background-color: #dfe5e8;
    border: 3px solid #dfe5e8;
    border-radius: 10px 10px 10px 0;
    transition: all 0.2s;
    box-shadow: unset!important;
  }  
  .rifiuto:hover{
    background-color: #dfe5e8;
    border: 3px solid black;
  }
  .consenso-rifiutato{
    color: var(--coloreprimario);
    display: none;
    margin-top: 20px;
    font-size: 20px;
  }
  .consenso-rifiutato.mostra{
    display: block;
  }

  input[type='checkbox']{
    accent-color: var(--coloreprimario);
    min-width: 13px;
    width: 13px;
    min-height: 13px;
    height: 13px;
  }

  .accettazioni-varie label{
    display: flex;
    align-items: flex-start;
    text-align: left;
    margin-bottom: 10px;
  }  
  .accettazioni-varie label input[type='checkbox']{
    margin-top: 10px;
    margin-right: 15px;
  }

  .pulsanti-azioni{
    gap: 30px;
  }
  @media (max-width: 1280px) {
    .interattiva{
      min-height: calc(100vh - 190px);
    }
  }
  @media (max-width: 768px) {
    .interattiva{
      min-height: calc(100vh - 220px);
    }
  }
</style>

<script>
  var page_id = <?php echo json_encode($p_id, JSON_HEX_TAG); ?>;
</script>

<main id="test-page" class="interattiva">
  <div class="container">
    <div class="row">
      <div class="col">
        <div class="px-4 py-5 text-center informativa">
          <h1 class="display-5 fw-bold">Disclaimer</h1>
          <div class="col-lg-9 mx-auto">
            <h3>Electronic versions of the materials you are seeking to access are being made available on this website in good faith and are for information purposes only.</h3>
            <p><strong>The materials you are seeking to access are not directed at and should not be accessed by persons resident or located in any jurisdiction where the furnishing or the availability of the materials to which you are seeking access would breach any applicable law or regulation.</strong></p>
            <p>Neither the materials you are seeking to access, nor any supplement thereto (the “Information”) constitute an offer to purchase, to acquire or to sell securities or a solicitation of an offer to purchase, to acquire or sell securities (a) in any jurisdiction in which such offer or solicitation is not authorised (“Restricted Jurisdictions”) or (b) to any person to whom it is unlawful to make such offer or solicitation (“Restricted Persons”). It is the responsibility of any person wishing to access the Information to ensure that this access does not violate applicable legislation or regulations and to ensure compliance with such applicable legislation or regulations.</p>
            <p>If you are not permitted to view materials on this website or are in any doubt as to whether you are permitted to view these materials, please exit this webpage. These materials must not be released or otherwise forwarded, distributed or sent in or into any jurisdiction in which such offers or sales are unlawful. Persons receiving such documents (including custodians, nominees, and trustees) must not distribute or send them (a) in, into or from a Restricted Jurisdiction or (b) to any Restricted Person.</p>
            <p><b>Confirmation of understanding and acceptance of disclaimer</b></p>
            <div class="accettazioni-varie">
              <label for="warrent"> <input type="checkbox" id="warrent"> Warrant that I am not (a) resident or located in a Restricted Jurisdiction and (b) a Restricted Person, and I agree that I will not transmit or otherwise send any materials contained in this website (a) in, into or from a Restricted Jurisdiction or (b) to any Restricted Person.</label>
              <label for="understood"> <input type="checkbox" id="understood"> I have read and understood the disclaimer set out above. I understand that it may affect my rights and I agree to be bound by its terms. I confirm that I am permitted to proceed to electronic versions of the materials.</label>
            </div>
            <div class="pulsanti-azioni d-grid d-sm-flex justify-content-sm-center">
              <button type="button" class="btn btn-lg px-4 gap-3 acconsento disabled">I AGREE</button>
              <button type="button" class="btn btn-lg px-4 rifiuto">I Do not Agree</button>
            </div>
          </div>
          <!-- <div class="consenso-rifiutato">
            <p>Senza consenso non è possibile accedere al contenuto riservato</p>
          </div> -->
        </div>
        <div class="contenuto">
        </div>
      </div>
    </div>
  </div>
</main>

<?php date_default_timezone_set('Europe/Rome'); ?>
<script>
  jQuery(document).ready(function($){
    /* mi salvo la data odierna, di inizio, e di fine evento */
    var adesso = new Date();
    /* in questo caso l'inizio è 20 novembre 2023 dopo le 17:25 */
    var inizio = new Date("2023-11-20T17:30:00.000Z");
    /* in questo caso la fine è 30 giugno 2022 */
    var fine = new Date("2029-08-30T00:00:00.000Z");
    /* trasformo tutto in secondi */
    var secondsInizioAdesso = adesso.getTime() / 1000; 
    var secondsInizio = inizio.getTime() / 1000;
    var secondsFine = fine.getTime() / 1000; 
    /* console.log({secondsInizioAdesso, secondsInizio, secondsFine}); */
    /* se la data è compresa nell'intervallo */

    $('.accettazioni-varie input').on('change', function(){
      if ($('.accettazioni-varie input').length == $('.accettazioni-varie input:checked').length) {
        $(".acconsento").removeClass('disabled').addClass('abilitato');
      } else {
        $(".acconsento").addClass('disabled').removeClass('abilitato');
      }
    })

    var nonCliccato = 1;
    $(".pulsanti-azioni").on('click', '.acconsento.abilitato', function(e) {
      /* se non è ancora stato cliccato il pulsante 'i agree' e se gli input di accettazione sono stati TUTTI accettati, prendi tramite ajax il contenuto richiesto */
      if ($('.accettazioni-varie input').length == $('.accettazioni-varie input:checked').length && nonCliccato === 1) {
        e.preventDefault();
        nonCliccato = 0;
        $('.consenso-rifiutato').removeClass('mostra');
        var url = "https://www.microtest.net/wp-admin/admin-ajax.php";
        $.ajax({
          url: url,
          type: 'POST',
          data: {
            action: 'acconsentito',
            id: page_id,
          },
          success: function(data){
            $("div.informativa").remove();
            $("div.contenuto").append(data);
            if ( (secondsInizioAdesso >= secondsInizio) && ( secondsInizioAdesso < secondsFine)){
                /* console.log('dentro intervallo'); */
                $('.nascondi-sezione').addClass('d-block');
              } else {
              /* console.log('fuori intervallo'); */
            }
          },
          error: function(error){
            console.log(error);
          }
        });
      }
    });

    $(".rifiuto").on('click', function(e) {
      e.preventDefault();
      /* $('.consenso-rifiutato').addClass('mostra'); */
      console.log("Rifiutato");
      window.location = 'https://www.microtest.net/<?php echo ICL_LANGUAGE_CODE; ?>';
    });
  });
</script>


<?php
  get_footer();