<?php
/**
 * Template Name: News Showcase Template
 * @link https://codex.wordpress.org/Template_Hierarchy
 * @package Microtest
 */

get_header();
?>

<main class="news-main">
  <div class="thumbnail-hero" style="background-image:url('<?= get_the_post_thumbnail_url() ?>')">
    <h1><?php the_title(); ?></h1>
  </div>
  <div class="newsGrid">
    <div class="container contieniNews">
      <?php
        $args = array(
            'posts_per_page'  => -1,
            'post_type'       => 'post',
            'post_status'     => 'publish',
            'category_name' => 'News',
            'posts_per_page' => 15,
            'paged' => ( get_query_var('paged') ? get_query_var('paged') : 1),
        );
        $the_query = new WP_Query( $args ); 
      
        while( $the_query->have_posts()): $the_query->the_post();
        
        if (get_field('e_un_redirect')) {
          $Link_news = get_permalink(get_field('link_redirect')->ID);
        } else {
          $Link_news = get_permalink();
        }
      ?>
      <a href="<?= $Link_news ?>" class="singleNews">
        <div class="contentSingleNews">
          <div class="immagineThumbnail" style="background-image: url('<?php echo get_the_post_thumbnail_url() ?>')">
          
            <?php /* echo $post->post_content;  */?>     
          </div>
          <div class="titolo">

            <span class="data"> <?= get_the_date('d M') ?>:</span>
            <?= $post->post_title; ?>
          </div>
          <div class="readMore">
            <p>
              <?php _e('Read more', 'microtest'); ?>
            </p>
          </div>
          
        </div>
      </a>
      <?php
        endwhile; 
      ?>
      <div class="searchPagination">
          <?php bootscore_pagination($the_query->max_num_pages);  ?>
        </div>
    </div>
  </div>
</main>

<?php get_footer();