<?php
add_action( 'init', 'create_EventsPost' );

function create_EventsPost()
{
  $labels = array(
    'name'               => __( 'Events' ),
    'singular_name'      => __( 'Event' ),
    'menu_name'          => __( 'Events' ),
    'name_admin_bar'     => __( 'Events' ),
    'add_new'            => __( 'Aggiungi nuovo' ),
    'add_new_item'       => __( 'Aggiungi nuovo evento' ),
    'new_item'           => __( 'Nuovo evento' ),
    'edit_item'          => __( 'Modifica evento' ),
    'view_item'          => __( 'Visualizza evento' ),
    'all_items'          => __( 'Tutte gli eventi' ),
    'search_items'       => __( 'Cerca evento' ),
    'parent_item_colon'  => __( 'Evento Genitore' ),
    'not_found'          => __( 'Evento non trovato' ),
    'not_found_in_trash' => __( 'Nessuna Evento nel cestino' )
  );

  $args = array(
		'labels'              => $labels,
		'public'              => true,
    'publicly_queryable'  => true,
    'exclude_from_search' => false,
    'query_var'           => true,
    'has_archive'         => true,
    'can_export'          => true,
    'menu_position'       => 10,
    'menu_icon'           => 'dashicons-calendar',
    'show_ui'             => true,
    'supports'            => array('title', 'editor', 'author', 'page-attributes', 'thumbnail', 'revisions', 'custom-fields')
	);

  register_post_type('event', $args);
}