<?php
/**
 * Template Name: Events
 * @link https://codex.wordpress.org/Template_Hierarchy
 * @package Microtest
 */

$args = array(
  'posts_per_page'  => -1,
  'post_type'       => 'event',
  'post_status'     => 'publish'
);
$the_events = new WP_Query( $args );

get_header();
?>

<main id="content" class="main-events">
    <div class="events-header">
        <div class="thumbnail-hero" style="background-image:url('<?= get_the_post_thumbnail_url() ?>')">
            <h1><?php the_title(); ?></h1>
        </div>
    </div>
    
    <div class="eventGrid">
      <div class="container contieniEvents">
        <div class="row">
          <?php 
            /* add_action( 'get_the_date', 'my_project_filter_publish_dates', 10, 3 );
            function my_project_filter_publish_dates( $the_date ) {            
                return date( 'd M Y:', strtotime( $the_date ) );
            } */
             function evento_futuro($data_jMY) {
              /* alcune sezioni devono comparire fra l'18 ottobre 2021 e il 30 Giugno 2022 */
              /* mi salvo la data odierna, di fine, e di fine evento */
              $adesso = new DateTime('now');
              /* $fine= DateTime::createFromFormat('j-M-Y', '18-Oct-2021');   */
              $fine= DateTime::createFromFormat('d/m/Y', $data_jMY);  
              /* semplifico la data perché contenga solo anno mese giorno */
              $adesso=$adesso->format('Y-m-d');
              $fine=$fine->format('Y-m-d');
              /* trasformo la data in secondi */
              $adesso = strtotime($adesso);
              $fine = strtotime($fine);
              return ["adesso"=> $adesso, "fine" => $fine];
            }
          ?>
          <?php if ( $the_events->have_posts() ) :
            while ( $the_events->have_posts() ) :
              $the_events->the_post(); ?>
                <div class="singleEvent col-12 col-lg-10 offset-lg-1">
                  <div class="contentSingleEvent">
                    <a href="<?= get_permalink() ?>" class="immagineThumbnail" style="background-image: url('<?php echo get_the_post_thumbnail_url() ?>'); pointer-events: none">
                      <?php /* echo $post->post_content;  */?>     
                    </a>
                    <div class="testo">
                      <div href="<?= get_permalink() ?>" class="dataTitolo" style="color: black">
                        <p>
                          <span style="display: none"><?= get_the_date('d M Y') ?></span> <?= $post->post_title; ?>
                        </p>
                      </div>
                      <div class="exerpt">
                        <?= the_excerpt(); ?>
                      </div>
                    </div>
                    <?php 
                         $eventoInCorso = evento_futuro(get_field('event_date'));
                         if ( $eventoInCorso["adesso"] <= $eventoInCorso["fine"]) {?>
                          <div class="evento-prossimo">
                            <span>next</span>
                          </div>
                      <?php
                          }
                      ?>
                  </div>
                </div>
            <?php endwhile;
                endif; ?>
          </div>
      </div>
    </div>

<?php get_footer();