<?php
/**
 * Template Name: Shooting iscritti
 * @package Microtest
 */
get_header();
define('DONOTCACHEPAGE', true);

  // Connect to the WordPress database
  global $wpdb;

  // Run the query
  $results = $wpdb->get_results("SELECT email, slot, DATE_FORMAT(shooting_date,'%d/%m/%Y') shoot_date FROM `{$wpdb->prefix}shooting` ORDER BY `mtn_shooting`.`email` ASC");
  
  $resultsEmailInterne = $wpdb->get_results("SELECT * FROM `mtn_microtest_internal` ORDER BY `mtn_microtest_internal`.`email` ASC");

  if (isset($_GET['order']) && $_GET['order'] === 'slot') {
    $results = $wpdb->get_results("SELECT email, slot, DATE_FORMAT(shooting_date,'%d/%m/%Y') shoot_date FROM `{$wpdb->prefix}shooting` ORDER BY shooting_date, slot");
  }
?>

<meta name="robots" content="noindex">

<?php
  if ( $_GET['open'] === 'true' || $_SERVER['REMOTE_ADDR'] == '213.182.68.59') { ?>
     <main id="content" class="shooting-dates">

      <div class="container">
        <h1 class="text-center">Elenco Iscrizioni Shooting <br> <span style=" font-size: 0.7em; display: inline-block; transform: translateY(-5px); color: #5F727F">4 Settembre - 09:30/14:30</span><br> <span style=" font-size: 0.7em; display: inline-block; transform: translateY(-5px); color: #5F727F">19 Settembre - 09:30/13:10</span></h1>

        <style> 
          .iscritti span,
          .iscritti a{
            color: #009739;
            text-decoration: none;
            font-weight: 600;
          }
          <?php
            if (isset($_GET['order']) && $_GET['order'] === 'slot') { ?>
              .iscritti .ordine-slot{
                color: #000; 
                text-decoration: underline!important;
              }
              <?php } else { ?>
              .iscritti .ordine-nome{
                color: #000;
                text-decoration: underline!important;
              }
              <?php }
          ?>
        </style>

        <div class="iscritti" style="margin-top: 30px; margin-bottom: 30px;">
          <div class="row">
            
            <div class="single-iscritto col-5"> 
              <h3 class="numero-iscritti">
                Iscritti totali </span>
              </h3>
            </div>
            <div class="single-iscritto col-4">
                <h3><span><?php echo count($results) ?></h3> 
            </div>

            <div class="ordine-visualizzazione" style="display: flex; gap: 30px; margin-top: 15px; margin-bottom: 10px">
              <a href="<?php echo get_the_permalink() ?>?open=true" class="ordine-nome">
                <?php if (isset($_GET['order']) && $_GET['order'] === 'slot') { ?>
                    Ordina per email
                <?php } else { ?>
                    Ordinati per email
                <?php } ?>
              </a> 
              <a href="<?php echo get_the_permalink() ?>?open=true&order=slot" class="ordine-slot"> 
                <?php if (isset($_GET['order']) && $_GET['order'] === 'slot') { ?>
                  Ordinati per slot
                <?php } else { ?>
                  Ordina per slot 
                <?php } ?>
              </a>
            </div>
          </div>
          <div class="row">
            <?php $emailIscritti = [] ?>
            <?php 
            $numeroIscritti = 0;
            $dataScatto = '';
            foreach ($results as $result) { 
              $numeroIscritti++;
              $emailIscritti[] = $result->email;
              if ($dataScatto !== $result->shoot_date && $_GET['order'] === 'slot') {
                $dataScatto = $result->shoot_date;
                $numeroIscritti = 1;
              }
              ?>
              <div class="single-iscritto col-5" style="position: relative; --numeroiscritti: <?php echo $numeroIscritti ?>; <?php if ($numeroIscritti == 1 && $_GET['order'] === 'slot'){ echo 'margin-top: 30px';} ?>"> 
                <div class="con-before">
                  <?php echo $numeroIscritti ?>
                </div>
                <div class="mail">
                  <p style="margin-bottom: 0; margin-left: 10px"><?= $result->email ?></span></p>
                </div>
              </div>
              <div class="single-iscritto col-2" style="<?php if ($numeroIscritti == 1 && $_GET['order'] === 'slot'){ echo 'margin-top: 30px';} ?>">
                <p style="margin-bottom: 0"><span><?= substr($result->slot, 0, -3) ?></span></p>
              </div>
              <div class="single-iscritto col-2"  style="<?php if ($numeroIscritti == 1 && $_GET['order'] === 'slot'){ echo 'margin-top: 30px';} ?>">
                <p style="margin-bottom: 0"><span><?= $result->shoot_date ?></span></p>
              </div>
          <?php } ?>
          </div>

          <style>
            .con-before{
              position: absolute;
              top: 59%;
              left: 0;
              font-size: .7em;
              color: #009739;
              font-weight: 600;
              transform: translateY(-50%);
              display: block;
            }
          </style>
        </div>


        <div class="non-ancora-iscritti" style="margin-top: 15px; margin-bottom: 30px;">
          <div class="row">
            
            <div class="single-iscritto col-5"> 
              <h3 class="numero-iscritti">
                Non ancora iscritti </span> 
              </h3>
            </div>
            <div class="single-iscritto col-4">
                <h3><span><?php echo (count($resultsEmailInterne) - count($results)) ?></h3> 
            </div>

          </div>
          
          <div class="row">
            <?php foreach ($resultsEmailInterne as $result) { 
              if (!(in_array($result->email, $emailIscritti))) { ?>
                
                <div class="single-iscritto col-12"> 
                  <div class="mail">
                    <p style="margin-bottom: 0"><?= $result->email ?></span></p>
                  </div>
                </div>
              <?php } 
              ?>
          <?php } ?>
          </div>
        </div>
      </div>
    </main>
  <?php  } else {
    header("Location: " . home_url());
    exit;
  } ?>



<script>
  jQuery(document).ready(function($) {
    
  });
</script>
<?php 
  get_footer();
