<?php
  /*
	 * Template Post Type: applications
	 */

get_header();

$prods = new WP_Query(
	array(
		'post_type'			=> 'products'
	)
);

$products = array();

foreach($prods->posts as $prod) {
	$applications = get_field('applications', $prod->ID);

	foreach($applications as $app) {
		if ( get_post_field('post_name', get_post()) === $app->post_name) {
			array_push($products, $prod);
		}
	}
}
?>

<div id="content" class="site-content">
  <div id="primary" class="content-area container">
        <main id="main" class="site-main-application row">
			<div class="col-12 app-title">
				<div class="row">
					<div class="col-12 col-sm-5 col-md-6 col-lg-3">
						<div class="app-icon-big">
							<img src="<?php echo get_field('icona_home'); ?>"/>
						</div>
					</div>
					<div class="col-12 col-sm-7 col-md-6 app_page_title">
						<span>
							<h1><?php the_title(); ?></h1>
						</span>
					</div>
				</div>
			</div>

			<div class="col-12 application-description">
				<div class="row">
					<div class="col-4 col-md-2">
						<div class="app-icon-small">
							<img src="<?php echo get_field('icona_verde'); ?>" />
						</div>
					</div>
					<div class="block-left col-8 col-md-5">
						<?php echo get_field('block_left'); ?>
					</div>

					<div class="block-right col-12 col-md-5">
						<?php echo get_field('block_right'); ?>
					</div>
				</div>
			</div>

			<div class="col-12 ">
				<div class="row application-products">
					<?php foreach($products as $product) :
						 $id = $product->ID; ?>
						<div class="product-inner product-card"> 
								<a href="<?= get_permalink($id) ?>" class="product-image">
									<div class="product-labels"></div>
									<span class="product-image-inner">
										<img src="<?= get_the_post_thumbnail_url($product->ID, 'medium'); ?>" class="attachment-thegem-product-catalog" alt="dmt-shadow">
										<span class="woo-product-overlay"></span>
									</span>
								</a>
							
							<div class="line-separator"></div>
							<div class="prod-title">
								<a href="<?= get_permalink($id) ?>"><?= $product->post_title ?></a>
							</div>
						</div>
					<?php	endforeach ?>
				</div>
			</div>
		</main>
	</div>
</div>

<?php get_footer();